/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.handler;

import net.creeperhost.chickens.item.ItemLiquidEgg;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidEggFluidWrapper
implements IFluidHandler,
IFluidHandlerItem,
ICapabilityProvider {
    private final ItemStack container;

    public LiquidEggFluidWrapper(ItemStack container) {
        this.container = container;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        Item item = this.container.m_41720_();
        if (item instanceof ItemLiquidEgg) {
            ItemLiquidEgg itemLiquidEgg = (ItemLiquidEgg)item;
            return new FluidStack(itemLiquidEgg.getFluid(this.container), 1000);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @javax.annotation.Nullable
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (!resource.isFluidEqual(fluidStack)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    private FluidStack getFluid() {
        Item item = this.container.m_41720_();
        if (item instanceof ItemLiquidEgg) {
            ItemLiquidEgg itemLiquidEgg = (ItemLiquidEgg)item;
            return new FluidStack(itemLiquidEgg.getFluid(this.container), 1000);
        }
        return FluidStack.EMPTY;
    }

    @javax.annotation.Nullable
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        if (this.container.m_41613_() < 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (doDrain == IFluidHandler.FluidAction.EXECUTE) {
            this.container.m_41774_(1);
        }
        return fluidStack;
    }

    @NotNull
    public ItemStack getContainer() {
        return ItemStack.f_41583_;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }
}

